<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Office Tour, Couple tours, Family tours, Group tours, Solo tours, Adventure tours, Honeymoon tours, Luxury tours, Budget tours, Weekend tours, Day tours, Night tours, Seasonal tours, Custom tours, Cruises tours, City tours, Nature tours
        $categories = [
            [
                'name' => 'Office Tour',
                'slug' => 'office-tour',
                'description' => 'Office tour category',
                'status' => true,
                'order' => 1,
            ],
            [
                'name' => 'Couple tours',
                'slug' => 'couple-tours',
                'description' => 'Couple tours category',
                'status' => true,
                'order' => 2,
            ],
            [
                'name' => 'Family tours',
                'slug' => 'family-tours',
                'description' => 'Family tours category',
                'status' => true,
                'order' => 3,
            ],
            [
                'name' => 'Group tours',
                'slug' => 'group-tours',
                'description' => 'Group tours category',
                'status' => true,
                'order' => 4,
            ],
            [
                'name' => 'Solo tours',
                'slug' => 'solo-tours',
                'description' => 'Solo tours category',
                'status' => true,
                'order' => 5,
            ],
            [
                'name' => 'Adventure tours',
                'slug' => 'adventure-tours',
                'description' => 'Adventure tours category',
                'status' => true,
                'order' => 6,
            ],
            [
                'name' => 'Honeymoon tours',
                'slug' => 'honeymoon-tours',
                'description' => 'Honeymoon tours category',
                'status' => true,
                'order' => 7,
            ],
            [
                'name' => 'Luxury tours',
                'slug' => 'luxury-tours',
                'description' => 'Luxury tours category',
                'status' => true,
                'order' => 8,
            ],
            [
                'name' => 'Budget tours',
                'slug' => 'budget-tours',
                'description' => 'Budget tours category',
                'status' => true,
                'order' => 9,
            ],
            [
                'name' => 'Weekend tours',
                'slug' => 'weekend-tours',
                'description' => 'Weekend tours category',
                'status' => true,
                'order' => 10,
            ],
            [
                'name' => 'Day tours',
                'slug' => 'day-tours',
                'description' => 'Day tours category',
                'status' => true,
                'order' => 11,
            ],
            [
                'name' => 'Night tours',
                'slug' => 'night-tours',
                'description' => 'Night tours category',
                'status' => true,
                'order' => 12,
            ],
            [
                'name' => 'Seasonal tours',
                'slug' => 'seasonal-tours',
                'description' => 'Seasonal tours category',
                'status' => true,
                'order' => 13,
            ],
            [
                'name' => 'Custom tours',
                'slug' => 'custom-tours',
                'description' => 'Custom tours category',
                'status' => true,
                'order' => 14,
            ],
            [
                'name' => 'Cruises tours',
                'slug' => 'cruises-tours',
                'description' => 'Cruises tours category',
                'status' => true,
                'order' => 15,
            ],
            [
                'name' => 'City tours',
                'slug' => 'city-tours',
                'description' => 'City tours category',
                'status' => true,
                'order' => 16,
            ],
            [
                'name' => 'Nature tours',
                'slug' => 'nature-tours',
                'description' => 'Nature tours category',
                'status' => true,
                'order' => 17,
            ],
        ];

        foreach ($categories as $category) {
            \App\Models\Category::updateOrCreate([
                'slug' => $category['slug'],
            ], $category);
        }
    }
}
